using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class MainNPC : Collidable
{
    public string message;

    private float cooldown = 1.0f;
    private float last;

    protected override void Start()
    {
        base.Start();
        last = -cooldown;
    }

    protected override void OnCollide(Collider2D coll)
    {
        if (Time.time - last > cooldown)
        {
            last = Time.time;
            GameManager.instance.ShowText(message, 35, Color.white, transform.position + new Vector3(0, 0.16f, 0), Vector3.zero, cooldown);
        }
    }
}